/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.LsModuleView;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class LsBoxInfo {
    static ResourceBundle lspeedBundle;
    public static final String PROPNAME = "LsBoxInfo.lspeed.nways.ibm";
    public static final int SW_UNKNOWN = 0;
    public static final int SWE12_TP_v1 = 1;
    public static final int SWE24_TP_v1 = 2;
    public static final int SWE12F2_TPF_v1 = 3;
    public static final int SWE16_TP_v1 = 4;
    public static final int SWE10_F_v1 = 5;
    public static final int SWE10F2_FF_v1 = 6;
    public static final int SWE20_F_v1 = 7;
    public static final int SWF4_F_v1 = 8;
    public static final int SWE4_TX_v1 = 9;
    public static final int SWE4_FX_v1 = 10;
    public static final int SWE12_TP_v2 = 11;
    public static final int SWE24_TP_v2 = 12;
    public static final int SWE12F2_TPF_v2 = 13;
    public static final int SWE16_TP_v2 = 14;
    public static final int SWE10_F_v2 = 15;
    public static final int SWE10F2_FF_v2 = 16;
    public static final int SWE20_F_v2 = 17;
    public static final int SWF4_F_v2 = 18;
    public static final int SWE4_TX_v2 = 19;
    public static final int SWE4_FX_v2 = 20;
    public static final int SWA2_MOD = 21;
    public static final int SWE24_TPT = 22;
    public static final String[] ModuleDescr;
    public static final String[] LsTypes;
    public static final String[] LsTypesExt;
    public static final String[] iconGifs;
    public static final String[] ModPicGifs;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int Timeouts = 3;
    public static final int ServerProblems = 4;
    private GenModel deviceModel;
    private Hashtable modelList;
    private JdmBrowser lsBrowser;
    private Hashtable LsModuleList;
    private Hashtable AtmLecPortsList;
    private Hashtable ModuleGraphicList;
    private int deviceStatus;
    private boolean isApplication;
    private int maxNumOfSlots;
    private Thread buildModuleViewsThread;
    LsBoxInfo thisBoxInfo;
    boolean loggingOn;

    public LsBoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        block9: {
            this.LsModuleList = new Hashtable();
            this.AtmLecPortsList = new Hashtable();
            this.ModuleGraphicList = new Hashtable();
            this.loggingOn = false;
            this.isApplication = jdmBrowser.getIsApplication();
            if (this.isApplication) {
                this.loggingOn = Log.getLog().getLoggingState();
            }
            if (this.loggingOn) {
                System.out.println("LS:LsBoxInfo  constructor");
            }
            this.thisBoxInfo = this;
            lspeedBundle = ResourceBundle.getBundle("ibm.nways.lspeed.LsGeneralResources");
            this.lsBrowser = jdmBrowser;
            if (genModel == null) {
                this.deviceStatus = 4;
                if (this.loggingOn) {
                    System.out.println("LS: null device model - abort processing");
                    return;
                }
            } else {
                this.deviceModel = genModel;
                this.modelList = new Hashtable();
                try {
                    ModelInfo modelInfo = this.deviceModel.getInfo("Initial");
                    Serializable serializable = modelInfo.get("Initial.SysObjectID");
                    if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                        this.deviceStatus = 2;
                        if (this.loggingOn) {
                            System.out.println("LS: device not responding" + serializable.toString());
                        }
                        new BoxDownMsg(jdmBrowser.getFrame(), lspeedBundle.getString("LsRootFolderTitle"));
                        return;
                    }
                    this.deviceStatus = 1;
                    serializable = modelInfo.get("Initial.MaxNumOfSlots");
                    this.maxNumOfSlots = serializable instanceof Integer ? (Integer)serializable : 19;
                    this.createLsModuleList();
                    return;
                }
                catch (Exception exception) {
                    this.deviceStatus = 4;
                    if (!this.loggingOn) break block9;
                    System.out.println("LS:Error getting inital sysoid data");
                    exception.printStackTrace();
                    return;
                }
            }
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, LsBoxInfo lsBoxInfo) {
        navigationContext.put(PROPNAME, lsBoxInfo);
    }

    public static LsBoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (LsBoxInfo)navigationContext.get(PROPNAME, bl);
    }

    public JdmBrowser getLsBrowser() {
        return this.lsBrowser;
    }

    public int getMaxNumOfSlots() {
        return this.maxNumOfSlots;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public Hashtable getLsModuleList() {
        return this.LsModuleList;
    }

    public int getModuleType(Object object) {
        Object v = this.LsModuleList.get(object);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return 0;
    }

    public Hashtable getModuleGraphicList() {
        return this.ModuleGraphicList;
    }

    public int getNumOfLecPorts(Object object) {
        Object v = this.AtmLecPortsList.get(object);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return 0;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public GenModel getLsModel(String string) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent(string);
            if (genModel != null) {
                this.modelList.put(string, genModel);
            } else if (this.loggingOn) {
                System.out.println("LS: can't get model " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return genModel;
    }

    public void addModuleGraphic(Integer n, GraphicPanel graphicPanel) {
        this.ModuleGraphicList.put(n, graphicPanel);
    }

    public void updateAtmLecPorts(Integer n, Integer n2) {
        this.AtmLecPortsList.put(n, n2);
    }

    public void deleteModuleGraphic(Integer n) {
        GraphicPanel graphicPanel = (GraphicPanel)this.ModuleGraphicList.get(n);
        if (graphicPanel != null) {
            graphicPanel.dispose();
            this.ModuleGraphicList.remove(n);
        }
    }

    public void dispose() {
        if (this.ModuleGraphicList != null) {
            Enumeration enumeration = this.ModuleGraphicList.elements();
            while (enumeration.hasMoreElements()) {
                GraphicPanel graphicPanel = (GraphicPanel)enumeration.nextElement();
                graphicPanel.dispose();
            }
            this.ModuleGraphicList.clear();
        }
        if (this.buildModuleViewsThread != null && this.buildModuleViewsThread.isAlive()) {
            this.buildModuleViewsThread.stop();
        }
    }

    private void createLsModuleList() {
        Vector vector = new Vector();
        if (this.isApplication) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (this.loggingOn) {
            System.out.println("LS:createLsModuleList entry");
        }
        if (this.deviceModel == null) {
            this.deviceStatus = 4;
            if (this.loggingOn) {
                System.out.println("LS:null device model : abort processing");
            }
            return;
        }
        this.deviceStatus = 0;
        this.LsModuleList.clear();
        this.AtmLecPortsList.clear();
        try {
            GenModel genModel = this.getLsModel("LsModuleConfig");
            if (genModel != null) {
                vector = genModel.getRestOfInfo("ConfigData", "default", null, null);
            }
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            if (this.loggingOn) {
                System.out.println("LS:Failed to get LsModuleConfigInfo");
                exception.printStackTrace();
            }
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
            try {
                int n2;
                Serializable serializable = modelInfo.get("ConfigData.ModType");
                Integer n3 = (Integer)modelInfo.get("Index.Slot");
                Serializable serializable2 = modelInfo.get("ConfigData.Mezz1Status");
                Serializable serializable3 = modelInfo.get("ConfigData.Mezz2Status");
                Serializable serializable4 = modelInfo.get("ConfigData.ModNumBridgePorts");
                if (this.deviceStatus < 1) {
                    this.deviceStatus = 1;
                }
                if ((n2 = LsBoxInfo.determineModuleType(serializable, serializable2, serializable3)) >= 0) {
                    if (serializable4 instanceof Integer) {
                        this.AtmLecPortsList.put(n3, serializable4);
                    } else {
                        this.AtmLecPortsList.put(n3, new Integer(0));
                    }
                    this.LsModuleList.put(n3, new Integer(n2));
                    if (this.loggingOn) {
                        System.out.println("LS:new LsBoxInfo entry. Slot " + n3.toString() + " ModType " + LsTypes[n2]);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                if (this.deviceStatus == 1) {
                    this.deviceStatus = 3;
                } else if (this.deviceStatus < 2) {
                    this.deviceStatus = 2;
                }
                if (!this.loggingOn) break;
                classCastException.printStackTrace();
                System.out.println("LS: unusual device Status : " + this.deviceStatus);
                return;
            }
            ++n;
        }
    }

    public static int determineModuleType(Serializable serializable, Serializable serializable2, Serializable serializable3) {
        int n;
        int n2 = -1;
        int n3 = -2;
        boolean bl = true;
        int n4 = 2;
        int n5 = 3;
        int n6 = 4;
        int n7 = 5;
        int n8 = 6;
        int n9 = 8;
        int n10 = 9;
        int n11 = 10;
        if (!(serializable instanceof Integer)) {
            return n3;
        }
        int n12 = (Integer)serializable;
        if (n12 == 139) {
            return 21;
        }
        if (n12 != 96 && n12 != 107) {
            return n2;
        }
        if (!(serializable2 instanceof Integer) || !(serializable3 instanceof Integer)) {
            return 0;
        }
        int n13 = (Integer)serializable2;
        int n14 = (Integer)serializable3;
        block0 : switch (n13) {
            case 2: {
                switch (n14) {
                    case 1: {
                        n = 11;
                        break block0;
                    }
                    case 2: {
                        n = 12;
                        break block0;
                    }
                    case 3: {
                        n = 13;
                        break block0;
                    }
                    case 8: {
                        n = 14;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 3: {
                switch (n14) {
                    case 3: {
                        n = 18;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 4: {
                switch (n14) {
                    case 1: {
                        n = 15;
                        break block0;
                    }
                    case 3: {
                        n = 16;
                        break block0;
                    }
                    case 4: {
                        n = 17;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 5: {
                switch (n14) {
                    case 1: {
                        n = 20;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 6: {
                switch (n14) {
                    case 1: {
                        n = 19;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 9: {
                switch (n14) {
                    case 1: {
                        n = 22;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n12 == 96 && n > 0 && n <= 20) {
            n -= 10;
        }
        return n;
    }

    public String getSystemSink() {
        String string = lspeedBundle.getString("NoSystemSink");
        GenModel genModel = this.getLsModel("LsSystemSink");
        if (this.isApplication) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (genModel != null) {
            try {
                Vector vector = genModel.getRestOfInfo("ConfigData", "default", null, null);
                int n = 0;
                while (n < vector.size()) {
                    ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                    Integer n2 = (Integer)modelInfo.get("ConfigData.ModSystemSink");
                    if (n2 == 1) {
                        I18NMsgFormat i18NMsgFormat;
                        Integer n3 = (Integer)modelInfo.get("ConfigData.ModSinkTarget");
                        Object[] objectArray = new Object[]{modelInfo.get("Index.Slot"), modelInfo.get("ConfigData.ModSinkTarget")};
                        switch (n3) {
                            case 65: {
                                i18NMsgFormat = new I18NMsgFormat("ibm.nways.lspeed.LsGeneralResources", "SystemSinkProcessor", objectArray);
                                break;
                            }
                            case 255: {
                                i18NMsgFormat = new I18NMsgFormat("ibm.nways.lspeed.LsGeneralResources", "SystemSinkNoTarget", objectArray);
                                break;
                            }
                            default: {
                                i18NMsgFormat = new I18NMsgFormat("ibm.nways.lspeed.LsGeneralResources", "SystemSinkWithTarget", objectArray);
                            }
                        }
                        string = i18NMsgFormat.getTranslation();
                        if (this.loggingOn) {
                            System.out.println("LS:System sink is " + string);
                        }
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (this.loggingOn) {
                    System.out.println("LS:getSystemSink- bad data");
                }
                string = lspeedBundle.getString("UnknownSystemSink");
            }
        } else {
            string = lspeedBundle.getString("UnknownSystemSink");
            if (this.loggingOn) {
                System.out.println("LS:getSystemSink- no system sink model");
            }
        }
        return string;
    }

    public void buildModuleViews() {
        if (!this.LsModuleList.isEmpty() && (this.buildModuleViewsThread == null || this.buildModuleViewsThread != null && !this.buildModuleViewsThread.isAlive())) {
            this.buildModuleViewsThread = new BuildModuleViewsThread();
            this.buildModuleViewsThread.start();
        }
    }

    static {
        ModuleDescr = new String[]{"Unknown", "12-Port 10Base-T", "24-Port 10Base-T", "12-Port 10Base-T & FDDI", "16-Port 10Base-T LAN Access", "10-Port 10Base-FB/FL", "10-Port 10Base-FB/FL & FDDI", "20-Port 10Base-FB/FL ", "FDDI  (2 DAS (A/B) ports)", "4-Port  100Base-TX", "4-Port  100Base-FX", "12-Port 10Base-T", "24-Port 10Base-T", "12-Port 10Base-T & FDDI", "16-Port 10Base-T LAN Access", "10-Port 10Base-FB/FL", "10-Port 10Base-FB/FL & FDDI", "20-Port 10Base-FB/FL", " FDDI  (2 DAS  (A/B) ports)", "4-Port  100Base-TX", "4-Port  100Base-FX", "ATM /Packet Channel", "24-Port Ethernet Telco"};
        LsTypes = new String[]{"Unknown", "SWE12-TP v1", "SWE24-TP v1", "SWE12F2-TPF v1", "SWE16-TP v1", "SWE10-F v1", "SWE10F2-FF v1", "SWE20-F v1", "SWF4-F v1", "SWE4-TX v1", "SWE4-FX v1", "SWE12-TP v2", "SWE24-TP v2", "SWE12F2-TPF v2", "SWE16-TP v2", "SWE10-F v2", "SWE10F2-FF v2", "SWE20-F v2", "SWF4-F v2", "SWE4-TX v2", "SWE4-FX v2", "SWA2-MOD", "SWE24-TPT"};
        LsTypesExt = new String[]{"Unknown", "SWE12-TP", "SWE24-TP", "SWE12F2-TPF", "SWE16-TP", "SWE10-F", "SWE10F2-FF", "SWE20-F", "SWF4-F", "SWE4-TX", "SWE4-FX ", "SWE12-TP", "SWE24-TP", "SWE12F2-TPF", "SWE16-TP", "SWE10-F", "SWE10F2-FF", "SWE20-F", "SWF4-F", "SWE4-TX", "SWE4-FX", "SWA2-MOD", "SWE24-TPT"};
        iconGifs = new String[]{"unknownSW.gif", "SWE12TP.gif", "SWE24TP.gif", "SWE12F2TPF.gif", "SWE16TP.gif", "SWE10F.gif", "SWE10F2FF.gif", "SWE20F.gif", "SWF4F.gif", "SWE4TX.gif", "SWE4FX.gif", "SWE12TP.gif", "SWE24TP.gif", "SWE12F2TPF.gif", "SWE16TP.gif", "SWE10F.gif", "SWE10F2FF.gif", "SWE20F.gif", "SWF4F.gif", "SWE4TX.gif", "SWE4FX.gif", "SWA2MOD.gif", "SWE24TPT.gif"};
        ModPicGifs = new String[]{"unknownMod.gif", "ME12TP.gif", "ME24TP.gif", "ME12F2TPF.gif", "ME16TP.gif", "ME10F.gif", "ME10F2FF.gif", "ME20F.gif", "MF4F.gif", "ME4TX.gif", "ME4FX.gif", "ME12TP.gif", "ME24TP.gif", "ME12F2TPF.gif", "ME16TP.gif", "ME10F.gif", "ME10F2FF.gif", "ME20F.gif", "MF4F.gif", "ME4TX.gif", "ME4FX.gif", "MA2MOD.gif", "ME24TPT.gif"};
    }

    private class BuildModuleViewsThread
    extends Thread {
        Integer Slot;
        LsBoxInfo boxInfo;

        public void run() {
            NavigationContext navigationContext = new NavigationContext();
            LsBoxInfo.setInNavContext(navigationContext, LsBoxInfo.this.thisBoxInfo);
            Enumeration enumeration = LsBoxInfo.this.getLsModuleList().keys();
            while (enumeration.hasMoreElements()) {
                this.Slot = (Integer)enumeration.nextElement();
                LsModuleView lsModuleView = new LsModuleView(this.Slot);
                lsModuleView.getGraphicFor(null, null, navigationContext, false);
            }
        }

        BuildModuleViewsThread() {
            LsBoxInfo.this = LsBoxInfo.this;
        }
    }
}

